<?php

namespace UtillzCore\Inc\Src\Submission\Modules\Fields;

use \UtillzCore\Inc\Src\Submission\Submission;
use \UtillzCore\Inc\Src\Submission\Modules\Module;
use \UtillzCore\Inc\Src\Request\Custom_Request;
use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Validation;

class Fields extends Module {

    public function controller() {

        return [
            'form' => new Form( Form::Storage_Request ),
            'title' => $this->props->title,
            'fields' => $this->props->fields,
            'strings' => (object) [
                'not_found' => esc_html__('No listing fields were found. Create some by editing the listing type and then navigate to Listing > Fields.', 'utillz-core'),
            ]
        ];

    }

    public function validation() {

        $request = new Custom_Request('input');
        $form = new Form( Form::Storage_Request );
        $submission = new Submission( $request->get('type') );

        $terms = [];

        foreach( $submission->tabs[ $this->props->group ]['content'] as $item ) {
            if( $item->fields->is_submit_form && isset( $item->fields->required ) && $item->fields->required == true ) {

                $field = $form->create(
                    Ucore()->prefix_item( $item )
                );

                if( empty( $field->props->id ) ) {
                    continue;
                }

                $terms[ $field->props->id ] = 'required';

            }
        }

        $validation = new Validation();
		$response = $validation->validate( $request->params, $terms );

        return $response;

    }

}
